package com.dss.sdk.api.resp;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 获取法定代表人授权链接
 */
@Data
@Accessors(chain = true)
public class ZxcaApiCorpLegalAuthUrlResponse implements Serializable {
    private static final long serialVersionUID = -3896581173339298640L;

    /**
     * 认证订单ID
     */
    private String transactionId;

    /**
     * 认证订单状态，详见字典
     */
    private String transactionStatus;

    /**
     * 当前认证状态，详见字典
     */
    private String verificationStatus;

    /**
     * 法人授权链接
     */
    private String legalRepAuthUrl;

    /**
     * 法定代表人授权长链
     */
    private String nativeAuthLink;

    /**
     * 授权截止时间：需要在此时间前邀请法人完成授权，过期链接会失效，需要重新获取新的授权链接；
     * yyyy-MM-dd HH:mm:ss
     */
    private String expireTime;
}
