package com.dss.sdk.api.resp;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 打款金额验证
 */
@Data
@Accessors(chain = true)
public class ZxcaApiCorpPayAccountVerifyResponse implements Serializable {
    private static final long serialVersionUID = -3896581173339298640L;

    /**
     * 认证订单ID
     */
    private String transactionId;

    /**
     * 认证订单状态，详见字典
     */
    private String transactionStatus;

    /**
     * 当前认证状态，详见字典
     */
    private String verificationStatus;

    /**
     * 对公打款验证状态：进行中(in_progress)、成功(success)、失败(failed)
     */
    private String paymentVerificationStatus;

    /**
     * 金额验证状态：验证成功(success)、验证失败(failed)
     */
    private String amountVerificationStatus;

    /**
     * 剩余金额验证次数：默认有3次金额的验证次数，当剩余0时对公账户验证失败，需要重新发起对公账户验证
     */
    private Integer remainInputVerificationTimes;
}
