package com.dss.sdk.api.resp;

import com.dss.sdk.api.vo.*;
import lombok.Data;

import java.io.Serializable;

@Data
public class ZxcaCorpDetailResponse implements Serializable {
    /**
     * 订单ID
     */
    private String transactionId;
    /**
     * 客户系统中的用户唯一标识
     */
    private String clientId;
    /**
     * 应用ID
     */
    private String appId;
    /**
     * 方案ID
     */
    private String planId;
    /**
     * 经办人认证订单ID
     */
    private String operatorUserTransactionId;
    /**
     * 认证验证方案：0=未知；1=实名手机号认证；2=人脸识别认证；3=银行账户认证；4=人工审核认证
     */
    private String verificationType;
    /**
     * 订单状态：
     * n_progress 进行中
     * closed 已结束
     * canceled 已取消
     * expired 已过期
     */
    private String transactionStatus;
    /**
     * 认证状态：
     * in_progress 认证进行中
     * success 认证成功
     * failed 认证失败
     * await_submit 待提交信息
     */
    private String verificationStatus;
    /**
     * 实名认证事件编码
     */
    private String verificationEventCode;
    /**
     * 订单结束并关闭时间
     */
    private String finishTime;
    /**
     * 认证结果描述，如：认证失败原因
     */
    private String resultNote;
    /**
     * 组织机构信息
     */
    private ZxcaOrgInfoVO orgInfo;
    /**
     * 法定代表人认证信息（当认证方式为法定代表人认证时返回）
     */
    private ZxcaLegalRepSelfVerifyInfoVO legalRepSelfVerificationInfo;
    /**
     * 法定代表人授权认证信息（当认证方式为法定代表人授权认证时返回）
     */
    private ZxcaLegalRepAuthVerifyInfoVO legalRepAuthVerificationInfo;
    /**
     * 授权公函信息（当认证方式为授权公函+对公打款认证、授权公函邮寄原件认证时返回）
     */
    private ZxcaAuthLetterInfoVO authLetterInfo;
    /**
     * 对公打款信息（当认证方式为授权公函+对公打款认证时返回）
     */
    private ZxcaPaymentInfoVO paymentInfo;
    /**
     * 纸质资料信息（当认证方式为授权公函邮寄原件认证时返回）
     */
    private ZxcaPaperInfoVO paperInfo;
    /**
     * 经办人认证信息-存证版
     */
    private ZxcaOperatorInfoVO operatorInfo;
}
