package com.dss.sdk.api.resp;

import lombok.Data;

import java.io.Serializable;

@Data
public class ZxcaOperatorFaceInfoVO implements Serializable {

    /**
     * 人刷脸服务商渠道，详见字典
     */
    private String faceChannel;

    /**
     * 人脸识别状态，详见字典
     */
    private String faceVerificationStatus;

    /**
     * 人脸识别结果描述
     */
    private String faceVerificationResultNote;

    /**
     * 人脸识别结果时间
     */
    private String faceVerificationFinishTime;

    /**
     * 人脸底图图片ID（仅人脸通过时返回）
     * 如需下载文件，需要调用"获取文件下载预签名地址"获取文件下载地址(preSignUrl)，在下载地址有效期之前下载文件
     */
    private String facePhoto;

    /**
     * 人脸相似度得分（仅人脸通过时返回）
     */
    private String faceSimilarity;

    /**
     * 活体检测得分（仅人脸通过时返回）
     */
    private String faceLiveRate;

    /**
     * 服务商名称
     */
    private String supplierName;

}
