package com.dss.sdk.api.resp;

import lombok.Data;

import java.io.Serializable;

@Data
public class ZxcaOperatorPersonInfoVO implements Serializable {
    /**
     * 姓名
     */
    private String realName;

    /**
     * 个人证件类型，详见字典
     */
    private String idCertType;

    /**
     * 证件号码
     */
    private String idCertNo;

    /**
     * 证件头像面图片ID
     * 如需下载文件，需要调用"获取文件下载预签名地址"获取文件下载地址(preSignUrl)，在下载地址有效期之前下载文件
     */
    private String idCardHeadPicture;

    /**
     * 证件背面图片ID
     * 如需下载文件，需要调用"获取文件下载预签名地址"获取文件下载地址(preSignUrl)，在下载地址有效期之前下载文件
     */
    private String idCardBackPicture;

    /**
     * 性别
     */
    private String sex;

    /**
     * 民族
     */
    private String fork;

    /**
     * 生日
     */
    private String birthday;

    /**
     * 住址
     */
    private String address;

    /**
     * 证件颁发机构
     */
    private String issueAuthority;

    /**
     * 证件有效期开始日期
     */
    private String validStartDate;

    /**
     * 证件是否长期有效：yes-是，no-否
     */
    private String isValidLongTerm;

    /**
     * 证件有效期截止日期
     */
    private String validEndDate;
}
