package com.dss.sdk.api.service;

import com.dss.sdk.api.base.DefaultDssClient;
import com.dss.sdk.config.HttpConfig;

/**
 * @author Fadada
 */
public class DssClientService extends DefaultDssClient {
    /**
     * DssClientService
     *
     * @throws
     * @Param: serverUrl 接口地址
     * @Param: appId 应用id
     * @Param: appSecret 应用Secret
     */
    public DssClientService(String serverUrl, String appId, String appSecret) {
        super(serverUrl, appId, appSecret);
    }

    /**
     * DssClientService
     *
     * @throws
     * @Param: serverUrl 接口地址
     * @Param: appId 应用id
     * @Param: appSecret 应用Secret
     * @Param: signType 加密方式
     */
    public DssClientService(String serverUrl, String appId, String appSecret, String signType) {
        super(serverUrl, appId, appSecret);
        super.setSignType(signType);
    }

    /**
     * DssClientService
     *
     * @throws
     * @Param: serverUrl 接口地址
     * @Param: appId 应用id
     * @Param: appSecret 应用Secret
     * @Param: httpConfig 请求配置
     */
    public DssClientService(String serverUrl, String appId, String appSecret, HttpConfig httpConfig) {
        super(serverUrl, appId, appSecret, httpConfig);
    }

    /**
     * DssClientService
     *
     * @throws
     * @Param: serverUrl 接口地址
     * @Param: appId 应用id
     * @Param: appSecret 应用Secret
     * @Param: connectTimeout 连接超时时间
     * @Param: readTimeout 响应超时时间
     */
    public DssClientService(String serverUrl, String appId, String appSecret, int connectTimeout, int readTimeout) {
        super(serverUrl, appId, appSecret, connectTimeout, readTimeout);
    }

    /**
     * DssClientService
     *
     * @throws
     * @Param: serverUrl 接口地址
     * @Param: appId 应用id
     * @Param: appSecret 应用Secret
     * @Param: connectTimeout 连接超时时间
     * @Param: readTimeout 响应超时时间
     * @Param: signType 加密方式
     */
    public DssClientService(String serverUrl, String appId, String appSecret, int connectTimeout, int readTimeout, String signType) {
        super(serverUrl, appId, appSecret, connectTimeout, readTimeout, signType);
    }
}
