package com.dss.sdk.api.vo;

import lombok.Data;

/**
 * <h3>签名信息详情</h3>
 * <p></p>
 *
 * @author Fadada
 * @since 2021/11/24
 */
@Data
public class ContractSignatureInfoVO {
    //验签状态
    // "签名是否有效"
    private Boolean isValid;
    // "文件完整性校验，文件是否被篡改,true 通过，未被篡改 false 未通过，可能被篡改"
    private Boolean integrityValid;
    // "文件完整性校验结果文案"
    private String integrityVerifyText;
    // "身份认证有效性，身份认证是否有效，true 通过，身份认证有效 false 未通过，身份认证异常"
    private Boolean identityValid;
    // "身份认证有效性校验结果文案"
    private String identityVerifyText;
    // "时间戳有效性，时间戳是否有效，true 通过，时间戳有效 false 未通过，时间戳无效"
    private Boolean timestampValid;
    // "时间戳有效性校验结果文案"
    private String timestampVerifyText;
    // "是否有时间戳，true 有时间戳 false 无时间戳"
    private Boolean timestampFlag;
    // "是否有时间戳的文案"
    private String timestampText;
    // "是否内部签名值，true 是 false 不是"
    private Boolean internalSignatureFlag;
    // "是否内部签名值文案"
    private String internalSignatureText;
    //签名详细信息
    // "签章域的名称,定位签名的唯一标识"
    private String name;
    // "证书颁发机构"
    private String o;
    // "签名人 如： 2@九江市三人行科技有限公司@91360406MA35FJGJ8T@583410"
    private String signer;
    // "证书序列号 如：2021102600132515"
    private String certSerialNo;
    // "签署时间 如：2021/01/06 18:06:24 +08'00'"
    private String signedTime;
    // "签名算法 如：SM3withSM2、SHA256withRSA"
    private String signatureAlgorithm;
    // "证书有效期开始时间 如：2020-04-27 17:18:56 +08'00' "
    private String certBeginTime;
    // "证书有效期结束时间 如：2022-05-27 23:59:59 +08'00' "
    private String certEndTime;
    //签名域定位信息
    // "签名所在页码，从0开始"
    private Integer pageNum;
    // "签名域中心点，x坐标"
    private Float x;
    // "签名域中心点，y坐标"
    private Float y;
    // "签名域矩形框高度"
    private Float height;
    // "签名域矩形框宽度"
    private Float width;
    // "文档页高度"
    private Float pageHeight;
    /**
     * 时间戳时间
     */
    private Long timestampTime;
}
