package com.dss.sdk.api.vo;

import lombok.Data;

import java.io.Serializable;

@Data
public class ZxcaLegalRepAuthVerifyInfoVO implements Serializable {
    /**
     * 法定代表人姓名
     */
    private String legalRepName;

    /**
     * 法定代表人证件类型
     */
    private String legalRepIdCertType;

    /**
     * 法定代表人证件号码
     */
    private String legalRepIdCertNo;

    /**
     * 法定代表人授权同意时间
     */
    private String legalRepAuthTime;

    /**
     * 法定代表人认证状态 详见字典
     */
    private String legalRepVerificationStatus;

    /**
     * 法定代表人认证方式 详见字典
     */
    private String legalRepVerificationType;

    /**
     * 法定代表人认证结果描述
     */
    private String legalRepVerificationResultNote;

    /**
     * 法定代表人认证结果时间
     */
    private String legalRepVerificationFinishTime;

    /**
     * 法定代表人刷脸服务商渠道 详见字典（仅法定代表人人脸识别认证时返回）
     */
    private String faceChannel;

    /**
     * 人脸底图（仅人脸通过时返回）
     */
    private String facePhoto;

    /**
     * 人脸相似度得分（仅人脸通过时返回）
     */
    private String faceSimilarity;

    /**
     * 活体检测得分（仅人脸通过时返回）
     */
    private String faceLiveRate;

    /**
     * 实名手机号（仅法定代表人手机号认证时返回）
     */
    private String mobile;

    /**
     * 验证通过的短信验证码（手机号认证通过时返回）
     */
    private String verificationCode;
}
