package com.dss.sdk.api.vo;

import lombok.Data;

import java.io.Serializable;

@Data
public class ZxcaPaymentInfoVO implements Serializable {

    /**
     * 对公打款验证方式 详见字典
     */
    private String paymentType;

    /**
     * 对公打款验证状态 详见字典
     */
    private String paymentVerificationStatus;

    /**
     * 豸信打款状态 详见字典
     */
    private String payInStatus;

    /**
     * 豸信打款成功时间
     */
    private String payInSuccessTime;

    /**
     * 企业打款状态 详见字典
     */
    private String payOutStatus;

    /**
     * 收到企业打款时间
     */
    private String payOutSuccessTime;

    /**
     * 企业对公账户名称
     */
    private String corpBankAccountName;

    /**
     * 企业对公账户账号
     */
    private String corpBankAccountNo;

    /**
     * 企业开户行名称（名称与联行号至少有一个）
     */
    private String corpBankName;

    /**
     * 企业开户行联行号（名称与联行号至少有一个）
     */
    private String corpBankId;

    /**
     * 对公打款验证结果描述
     */
    private String paymentVerificationResultNote;

    /**
     * 对公打款验证结果时间
     */
    private String paymentVerificationFinishTime;
}
