package com.dss.sdk.constants;

/**
 * 公用常量类
 */
public abstract class Constants {
    /**
     * 默认时间格式
     **/
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    /**
     * Date默认时区
     **/
    public static final String DATE_TIMEZONE = "GMT+8";
    /**
     * UTF-8字符集
     **/
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String SESSION = "session";
    public static final String X_REQUEST_ID = "X-Request-Id";
    /**
     * 默认流式读取缓冲区大小
     **/
    public static final int READ_BUFFER_SIZE = 1024 * 4;
    /**
     * HTTP请求相关
     **/
    public static final String METHOD_POST = "POST";
    public static final String MIME_TYPE_DEFAULT = "application/octet-stream";
    /**
     * 响应编码
     */
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    /**
     * 字符串常量标识
     **/
    public static final String STRING_0_FLAG = "0";
    /**
     * 字符串常量标识
     **/
    public static final int INT_0_FLAG = 0;
    public static final int INT_3_FLAG = 3;
    /**
     * 重试最大次数
     **/
    public static final int MAX_RETRIES = 20;
}
