package com.dss.sdk.enums;

public enum SignDataEnum {
    APPID("X-DSS-AppId", "应用id", "header"),
    SIGNTYPE("X-DSS-SignType", "签名方式", "header"),
    SIGN("X-DSS-Sign", "签名值", "header"),
    LANGUAGE("X-DSS-Language", "语言", "header"),
    TIMESTAMP("X-DSS-Timestamp", "时间戳", "header"),
    NONCE("X-DSS-Nonce", "随机数", "header"),
    BIZCONTENT("bizContent", "数据", "body"),
    ;

    private String name;
    private String desc;
    private String dataType;


    SignDataEnum(String name, String desc, String dataType) {
        this.name = name;
        this.desc = desc;
        this.dataType = dataType;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }

    public String getDataType() {
        return dataType;
    }
}
