package com.dss.sdk.enums;

import java.util.Arrays;

public enum SignTypeEnum {
    SM3("SM3", "SM3"),
    SHA256("HMAC-SHA256", "HMAC-SHA256");

    private final String value;

    private final String valueInFact;

    private SignTypeEnum(String value, String valueInFact) {
        this.value = value;
        this.valueInFact = valueInFact;
    }

    public static SignTypeEnum getAlgEnum(String value) {
        return Arrays.asList(SignTypeEnum.values()).stream().filter(e -> value.equals(e.getValue())).findFirst().orElse(null);
    }

    public String getValue() {
        return value;
    }

    public String getValueInFact() {
        return valueInFact;
    }
}
