package com.dss.sdk.request;

import com.dss.sdk.exception.ApiRuleException;

import java.util.Map;

/**
 * 请求接口
 *
 * @author Fadada
 */
public interface DssRequest {
    /**
     * 获取Http method，例如GET,POST
     *
     * @return
     */
    String getHttpMethod();

    /**
     * 获取Http id
     *
     * @return
     */
    String getHttpId();

    /**
     * 校验
     */
    void validate() throws ApiRuleException;

    /**
     * 对象转map
     */
    Map<String, Object> toMap() throws ApiRuleException;
}
