package com.dss.sdk.response;

import com.dss.sdk.base.BaseHttpRes;
import lombok.NoArgsConstructor;

/**
 * 基础响应信息
 *
 * @author Fadada
 */
@NoArgsConstructor
public class DssResponse<T> extends BaseHttpRes {
    private T data;

    public DssResponse(String code, boolean success, String path) {
        super.setCode(code);
        super.setSuccess(success);
        super.setPath(path);
    }

    public static DssResponse getInstance() {
        return new DssResponse();
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }
}
