package com.dss.sdk.stratey;

import com.dss.sdk.exception.ApiException;
import com.dss.sdk.utils.json.GsonUtil;

import java.lang.reflect.ParameterizedType;
import java.util.List;

/**
 * @author Fadada
 * 2021/9/8 16:32:01
 */
public class DefaultJsonStrategy implements JsonStrategy {
    @Override
    public String toJson(Object object) throws ApiException {
        return GsonUtil.toJsonStr(object);
    }

    @Override
    public <T> T toBean(String json, ParameterizedType parameterizedType) throws ApiException {
        return GsonUtil.toBean(json, parameterizedType);
    }

    @Override
    public <T> T toBean(String json, Class<T> clzz) throws ApiException {
        return GsonUtil.toBean(json, clzz);
    }

    @Override
    public <T> List<T> toList(String json, Class<T> clzz) throws ApiException {
        return GsonUtil.toList(json, clzz);
    }
}
