package com.dss.sdk.utils.http;

import java.util.HashMap;
import java.util.Map;

/**
 * API请求参数容器
 *
 * @author Fadada
 */
public class RequestParametersHolder {
    private String requestUrl;
    private Integer httpStatusCode;
    private String responseBody;

    private HashMap protocalMustParams;
    private HashMap protocalOptParams;
    private HashMap applicationParams;

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public HashMap getProtocalMustParams() {
        return this.protocalMustParams;
    }

    public void setProtocalMustParams(HashMap protocalMustParams) {
        this.protocalMustParams = protocalMustParams;
    }

    public HashMap getProtocalOptParams() {
        return this.protocalOptParams;
    }

    public void setProtocalOptParams(HashMap protocalOptParams) {
        this.protocalOptParams = protocalOptParams;
    }

    public HashMap getApplicationParams() {
        return this.applicationParams;
    }

    public void setApplicationParams(HashMap applicationParams) {
        this.applicationParams = applicationParams;
    }

    public Map<String, Object> getAllParams() {
        Map<String, Object> params = new HashMap<String, Object>();
        if (protocalMustParams != null && !protocalMustParams.isEmpty()) {
            params.putAll(protocalMustParams);
        }
        if (protocalOptParams != null && !protocalOptParams.isEmpty()) {
            params.putAll(protocalOptParams);
        }
        if (applicationParams != null && !applicationParams.isEmpty()) {
            params.putAll(applicationParams);
        }
        return params;
    }

    public Integer getHttpStatusCode() {
        return httpStatusCode;
    }

    public void setHttpStatusCode(Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }
}
