package com.dss.sdk.utils.log;

import com.dss.sdk.utils.string.StrUtil;
import org.apache.log4j.PropertyConfigurator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * @author: Fadada
 */
public class DssLogUtil {
    private static Boolean initLog = false;

    /**
     * 设置打印日志
     */
    public static void logVersion() {
        if (initLog) {
            return;
        }
        Properties props = new Properties();
        InputStream in = DssLogUtil.class.getClassLoader().getResourceAsStream("dss-version.properties");
        try {
            props.load(in);
        } catch (Throwable e) {
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                }
            }
        }
        String version = props.getProperty("dssVersion");
        if (StrUtil.isEmpty(version) || version.contains("@")) {
            version = "";
        }
        in = DssLogUtil.class.getClassLoader().getResourceAsStream("dss-Log4j.properties");
        try {
            Properties log4jProperties = new Properties();
            log4jProperties.load(in);
            // 动态设置日志级别
            log4jProperties.setProperty("dssVersion", version);
            // 重新配置Log4j
            PropertyConfigurator.configure(log4jProperties);
            initLog = true;
        } catch (Throwable e) {
            initLog = true;
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                }
            }
        }
    }
}
