package com.dss.sdk.utils.string;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/**
 * 字符串工具类
 *
 * @version 2.0.0
 * @date: 2024/7/3
 */
public class StrUtil {
    /**
     * 字符串常量：{@code "null"} <br>
     * 注意：{@code "null" != null}
     */
    public static final String NULL = "null";

    /**
     * 字符串常量：空字符串 {@code ""}
     */
    public static final String EMPTY = "";

    /**
     * 字符串常量：空格符 {@code " "}
     */
    public static final String SPACE = " ";
    /**
     * 字符串常量：冒号 {@code ":"}
     */
    public static final String COLON = ":";
    /**
     * 字符串常量：减号（连接符） {@code "-"}
     */
    public static final String DASHED = "-";
    public static final String SLASH = "/";

    /**
     * 为空
     *
     * @param cs 字符串
     * @return 是否为空
     */
    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    /**
     * 不为空
     *
     * @param cs 字符串
     * @return 是否不为空
     */
    public static boolean isNotEmpty(CharSequence cs) {
        return !isEmpty(cs);
    }

    /**
     * 为null或者空
     *
     * @param cs 字符串
     * @return 是否为null或空
     */
    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs != null && (strLen = cs.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (!Character.isWhitespace(cs.charAt(i))) {
                    return false;
                }
            }

            return true;
        } else {
            return true;
        }
    }

    /**
     * 不为null或者空
     *
     * @param cs 字符串
     * @return 是否不为null或空
     */
    public static boolean isNotBlank(CharSequence cs) {
        return !isBlank(cs);
    }

    /**
     * 去除前后空格
     *
     * @param str 字符串
     * @return 字符串
     */
    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    /**
     * 去除空格后长度为0就返回null
     *
     * @param str 字符串
     * @return 字符串
     */
    public static String trimToNull(String str) {
        String ts = trim(str);
        return isEmpty(ts) ? null : ts;
    }

    /**
     * 去除空格，为null返回空字符串
     *
     * @param str 字符串
     * @return 字符串
     */
    public static String trimToEmpty(String str) {
        return str == null ? "" : str.trim();
    }

    public static String blankToDefault(CharSequence str, String defaultStr) {
        return isBlank(str) ? defaultStr : str.toString();
    }

    /**
     * 清除字典中值为空的项。
     *
     * @param <V> 泛型
     * @param map 待清除的字典
     * @return 清除后的字典
     */
    public static <V> Map<String, V> cleanupMap(Map<String, V> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        Map<String, V> result = new HashMap<String, V>(map.size());
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry<String, V> entry : entries) {
            if (entry.getValue() != null) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    /**
     * 简化的UUID
     */
    public static String fastSimpleUUID() {
        return UUID.randomUUID().toString().replaceAll(DASHED, EMPTY);
    }
}
