package com.dss.sdk.utils.valida;

import com.dss.sdk.exception.ApiRuleException;
import com.dss.sdk.file.FileItem;
import com.dss.sdk.utils.string.StrUtil;

import java.util.List;

/**
 * @author Fadada
 */
public class RequestCheckUtils {
    public static final String ERROR_CODE_ARGUMENTS_MISSING = "40";
    public static final String ERROR_CODE_ARGUMENTS_INVALID = "41";

    public static void checkNotEmpty(Object value, String fieldName) throws ApiRuleException {
        if (value == null) {
            throw new ApiRuleException(ERROR_CODE_ARGUMENTS_MISSING, "client-error:Missing required arguments:" + fieldName + "");
        }
        if (value instanceof String) {
            if (((String) value).trim().length() == 0) {
                throw new ApiRuleException(ERROR_CODE_ARGUMENTS_MISSING, "client-error:Missing required arguments:" + fieldName + "");
            }
        }
    }

    public static void checkTwoNotEmpty(FileItem file, String fieldName1, String value2, String fieldName2) throws ApiRuleException {
        if (file == null && StrUtil.isBlank(value2)) {
            throw new ApiRuleException(ERROR_CODE_ARGUMENTS_MISSING, "client-error:Missing required arguments:" + fieldName1 + " or " + fieldName2 + "");
        }
    }

    public static void checkChooseOneNotEmpty(FileItem file, String fieldName1, String value2, String fieldName2) throws ApiRuleException {
        if (file != null && StrUtil.isNotBlank(value2)) {
            throw new ApiRuleException(ERROR_CODE_ARGUMENTS_MISSING, "client-error:Can only choose one arguments:" + fieldName1 + " or " + fieldName2 + "");
        }
    }

    public static void checkMaxLength(String value, int maxLength, String fieldName) throws ApiRuleException {
        if (value != null) {
            if (value.length() > maxLength) {
                throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid arguments:the string length of " + fieldName + " can not be larger than " + maxLength + ".");
            }
        }
    }

    public static void checkMaxLength(FileItem fileItem, int maxLength, String fieldName) throws ApiRuleException {
        if (fileItem != null && fileItem.getFileLength() > maxLength) {
            throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid arguments:the file size of " + fieldName + " can not be larger than " + maxLength + ".");
        }
    }

    public static void checkMaxListSize(String value, int maxSize, String fieldName) throws ApiRuleException {
        if (value != null) {
            String[] list = value.split(",");
            if (list != null && list.length > maxSize) {
                throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid arguments:the array size of " + fieldName + " must be less than " + maxSize + ".");
            }
        }
    }

    public static void checkMaxListSize(List<String> list, int maxSize, String fieldName) throws ApiRuleException {
        if (list != null) {
            if (list != null && list.size() > maxSize) {
                throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid arguments:the array size of " + fieldName + " must be less than " + maxSize + ".");
            }
        }
    }

    public static void checkMaxValue(Long value, long maxValue, String fieldName) throws ApiRuleException {
        if (value != null) {
            if (value > maxValue) {
                throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid arguments:the value of " + fieldName + " can not be larger than " + maxValue + ".");
            }
        }
    }

    public static void checkMinValue(Long value, long minValue, String fieldName) throws ApiRuleException {
        if (value != null) {
            if (value < minValue) {
                throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid arguments:the value of " + fieldName + " can not be less than " + minValue + ".");
            }
        }
    }
}
