/*
 * Decompiled with CFR 0.152.
 */
package com.hiiso.bridge.outside.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.hiiso.bridge.json.JsonUtil;
import com.hiiso.bridge.outside.core.LineInfoHandler;
import com.hiiso.bridge.outside.entity.CoverageCollectData;
import com.hiiso.bridge.outside.entity.CoverageData;
import com.hiiso.bridge.outside.entity.CoverageFileFrequency;
import com.hiiso.bridge.outside.entity.coverage.CoverageFile;
import com.hiiso.bridge.outside.entity.coverage.CoverageIndex;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CoverageDataUtil {
    public static void write(CoverageData coverageData, OutputStream outputStream) {
        CoverageDataUtil.write(coverageData, outputStream, true);
    }

    public static void write(CoverageData coverageData, OutputStream outputStream, boolean isAutoClose) {
        CoverageDataUtil.write(new ArrayList<CoverageFile>(coverageData.get().values()), outputStream, isAutoClose);
    }

    public static void write(List<CoverageFile> coverageFiles, OutputStream outputStream) {
        CoverageDataUtil.write(coverageFiles, outputStream, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(List<CoverageFile> coverageFiles, OutputStream outputStream, boolean isAutoClose) {
        PrintWriter printWriter = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
            printWriter = new PrintWriter(outputStreamWriter);
            for (CoverageFile coverageFile : coverageFiles) {
                printWriter.println(JsonUtil.toJSONString((Object)coverageFile, (boolean)true));
            }
            printWriter.flush();
            if (!isAutoClose) return;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!isAutoClose) throw throwable;
                IoUtil.close((Closeable)outputStream);
                IoUtil.close((Closeable)outputStreamWriter);
                IoUtil.close(printWriter);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)outputStream);
        IoUtil.close((Closeable)outputStreamWriter);
        IoUtil.close((Closeable)printWriter);
        return;
    }

    public static void read(InputStream inputStream, LineInfoHandler lineInfoHandler) {
        CoverageDataUtil.read(inputStream, lineInfoHandler, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void read(InputStream inputStream, LineInfoHandler lineInfoHandler, boolean isAutoClose) {
        BufferedReader reader = null;
        InputStreamReader inputStreamReader = null;
        try {
            String line;
            inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            reader = new BufferedReader(inputStreamReader);
            while ((line = reader.readLine()) != null) {
                if (!StrUtil.isNotBlank((CharSequence)line) || lineInfoHandler == null) continue;
                lineInfoHandler.handle(line);
            }
            if (!isAutoClose) return;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException();
            }
            catch (Throwable throwable) {
                if (!isAutoClose) throw throwable;
                IoUtil.close((Closeable)inputStream);
                IoUtil.close((Closeable)inputStreamReader);
                IoUtil.close(reader);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)inputStream);
        IoUtil.close((Closeable)inputStreamReader);
        IoUtil.close((Closeable)reader);
        return;
    }

    public static void fusion(CoverageData coverageData, CoverageCollectData coverageCollectData) {
        if (coverageData == null || coverageCollectData == null) {
            return;
        }
        coverageData.get().forEach((path, coverageFile) -> {
            CoverageFileFrequency file = coverageCollectData.getFile((String)path);
            if (file != null) {
                boolean frequency = CoverageDataUtil.fusion(coverageFile.getLines(), file.getLines());
                frequency = CoverageDataUtil.fusion(coverageFile.getMethods(), file.getMethods()) || frequency;
                frequency = CoverageDataUtil.fusion(coverageFile.getBranches(), file.getBranches()) || frequency;
                boolean bl = frequency = CoverageDataUtil.fusion(coverageFile.getStatements(), file.getStatements()) || frequency;
                if (frequency) {
                    coverageFile.setFrequency(1);
                }
            }
        });
    }

    private static boolean fusion(List<? extends CoverageIndex> list, List<Integer> frequencyList) {
        if (CollUtil.isEmpty(list)) {
            return false;
        }
        if (CollUtil.isEmpty(frequencyList)) {
            list.clear();
            return false;
        }
        boolean frequency = false;
        int size = frequencyList.size();
        list.removeIf(coverageIndex -> {
            if (coverageIndex.getIndex() >= size) {
                return true;
            }
            Integer integer = (Integer)frequencyList.get(coverageIndex.getIndex());
            return integer == null || integer == -1;
        });
        for (CoverageIndex coverageIndex2 : list) {
            Integer integer = frequencyList.get(coverageIndex2.getIndex());
            if (!frequency) {
                frequency = integer > 0;
            }
            coverageIndex2.setFrequency(integer);
        }
        return frequency;
    }

    public static CoverageCollectData covert(CoverageData coverageData) {
        return CoverageDataUtil.covert(coverageData, true);
    }

    public static CoverageCollectData covert(CoverageData coverageData, boolean onlyCovered) {
        if (coverageData == null) {
            return new CoverageCollectData();
        }
        HashMap<String, CoverageFileFrequency> map = new HashMap<String, CoverageFileFrequency>();
        coverageData.get().forEach((path, coverageFile) -> {
            boolean bool;
            boolean bl2 = bool = !onlyCovered || coverageFile.getFrequency() > 0;
            if (bool) {
                CoverageFileFrequency coverageFileFrequency = new CoverageFileFrequency();
                coverageFileFrequency.setMethods(CoverageDataUtil.createIndexList(coverageFile.getMethods()));
                coverageFileFrequency.setLines(CoverageDataUtil.createIndexList(coverageFile.getLines()));
                coverageFileFrequency.setStatements(CoverageDataUtil.createIndexList(coverageFile.getStatements()));
                coverageFileFrequency.setBranches(CoverageDataUtil.createIndexList(coverageFile.getBranches()));
                map.put((String)path, coverageFileFrequency);
            }
        });
        return new CoverageCollectData(map);
    }

    private static int getMaxIndex(List<? extends CoverageIndex> list) {
        if (CollUtil.isEmpty(list)) {
            return -1;
        }
        int max = -1;
        for (CoverageIndex coverageIndex : list) {
            if (coverageIndex.getIndex() <= max) continue;
            max = coverageIndex.getIndex();
        }
        return max;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Integer> createIndexList(List<? extends CoverageIndex> list) {
        int maxIndex = CoverageDataUtil.getMaxIndex(list);
        if (maxIndex > -1) {
            void var4_6;
            ArrayList<Integer> existIndexes = new ArrayList<Integer>();
            for (CoverageIndex coverageIndex : list) {
                existIndexes.add(coverageIndex.getIndex());
            }
            ArrayList<Integer> integerList = new ArrayList<Integer>();
            boolean bl = false;
            while (var4_6 <= maxIndex) {
                if (existIndexes.contains((int)var4_6)) {
                    integerList.add(0);
                } else {
                    integerList.add(-1);
                }
                ++var4_6;
            }
            for (CoverageIndex coverageIndex : list) {
                integerList.set(coverageIndex.getIndex(), coverageIndex.getFrequency());
            }
            return integerList;
        }
        return null;
    }
}

