package com.hiiso.bridge.dataimpl.config;

import com.hiiso.bridge.tools.io.FileUtil;
import com.hiiso.bridge.tools.util.StrUtil;
import com.hiiso.bridge.data.IBridgeDataService;
import com.hiiso.bridge.dataimpl.core.BridgeLocalDataServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.File;

@Configuration
@ConditionalOnProperty(name = "file.storage.mode", havingValue = "local", matchIfMissing = true)
@Slf4j
public class BridgeFileConfig {

    @Value("${file.storage.local.root-path:}")
    private String rootPath;

    @ConditionalOnMissingBean(IBridgeDataService.class)
    @Bean
    public IBridgeDataService bridgeDataService() {
        log.info("数据存储模式：local");
        if (StrUtil.isBlank(rootPath)) {
            rootPath = new File("data").getAbsolutePath();
        }
        if (FileUtil.exist(rootPath)) {
            if (!FileUtil.isDirectory(rootPath)) {
                throw new RuntimeException(rootPath + "不是目录");
            }
        } else {
            FileUtil.mkdir(rootPath);
        }
        return new BridgeLocalDataServiceImpl(new File(rootPath));
    }

}
