package com.hiiso.bridge.dataimpl.config;

import com.hiiso.bridge.tools.io.FileUtil;
import com.hiiso.bridge.tools.util.StrUtil;
import com.hiiso.bridge.data.IBridgeTempLocalDataService;
import com.hiiso.bridge.dataimpl.core.BridgeTempLocalDataServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.File;

@Configuration
@Slf4j
public class BridgeTempConfig {

    @Value("${file.storage.temp-path:}")
    private String rootPath;

    @ConditionalOnMissingBean(IBridgeTempLocalDataService.class)
    @Bean
    public IBridgeTempLocalDataService bridgeTempLocalDataService() {
        if (StrUtil.isBlank(rootPath)) {
            rootPath = System.getProperty("java.io.tmpdir") + File.separator + "accurate-temp";
        }
        if (FileUtil.exist(rootPath)) {
            if (!FileUtil.isDirectory(rootPath)) {
                throw new RuntimeException(rootPath + "不是目录");
            }
        } else {
            FileUtil.mkdir(rootPath);
        }
        return new BridgeTempLocalDataServiceImpl(new File(rootPath));
    }

}
