package com.hiiso.bridge.dataimpl.core;

import com.hiiso.bridge.tools.io.FileUtil;
import com.hiiso.bridge.tools.util.ArrayUtil;
import com.hiiso.bridge.data.IBridgeDataService;
import com.hiiso.bridge.data.entity.BridgeFile;
import com.hiiso.bridge.data.entity.BridgeFileAttribute;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class BridgeLocalDataServiceImpl implements IBridgeDataService {

    private File rootPath;

    public BridgeLocalDataServiceImpl(File rootPath) {
        this.rootPath = rootPath;
    }

    public File getRootPath() {
        return rootPath;
    }

    private File getFile(BridgeFile file, boolean autoMkdirParent) {
        return getFile(file.getPathname(), autoMkdirParent);
    }


    private File getFile(String name, boolean autoMkdirParent) {
        File file = new File(rootPath, name);
        if (autoMkdirParent) {
            if (!FileUtil.exist(file.getParentFile())) {
                FileUtil.mkdir(file.getParentFile());
            }
        }
        return file;
    }

    @Override
    public BridgeFileAttribute attr(BridgeFile file) {
        File file1 = getFile(file, false);
        if (!FileUtil.exist(file1) || !FileUtil.isFile(file1)) {
            return null;
        }
        BridgeFileAttribute attribute = new BridgeFileAttribute();
        attribute.setLastModified(file1.lastModified());
        attribute.setSize(file1.length());
        return attribute;
    }

    @Override
    public boolean exist(BridgeFile file) {
        return FileUtil.exist(getFile(file, false));
    }

    @Override
    public void writeBytes(byte[] data, BridgeFile file) {
        FileUtil.writeBytes(data, getFile(file, true));
    }

    @Override
    public void writeFromStream(InputStream inputStream, BridgeFile file) {
        FileUtil.writeFromStream(inputStream, getFile(file, true));
    }

    @Override
    public void writeFromStream(InputStream inputStream, BridgeFile file, long fileSize) {
        FileUtil.writeFromStream(inputStream, getFile(file, true));
    }

    @Override
    public byte[] readBytes(BridgeFile file) {
        File file1 = getFile(file, false);
        if (!FileUtil.exist(file1)) {
            return null;
        }
        return FileUtil.readBytes(file1);
    }

    @Override
    public String readString(BridgeFile file, Charset charset) {
        return FileUtil.readString(getFile(file, false), charset);
    }

    @Override
    public InputStream getInputStream(BridgeFile file) {
        return FileUtil.getInputStream(getFile(file, false));
    }

    @Override
    public void delete(BridgeFile file) {
        File file1 = getFile(file, false);
        if (!FileUtil.exist(file1)) {
            return;
        }
        FileUtil.del(file1);
    }

    @Override
    public List<BridgeFile> list(BridgeFile file) {
        File file1 = getFile(file, false);
        if (!FileUtil.exist(file1)) {
            return null;
        }
        if (FileUtil.isFile(file1)) {
            return null;
        }
        File[] files1 = file1.listFiles();
        List<BridgeFile> files = new ArrayList<>();
        if (ArrayUtil.isNotEmpty(files1)) {
            for (File name : files1) {
                files.add(new BridgeFile(file.getPathname(), name.getName()));
            }
        }
        return files;
    }

    @Override
    public void rename(BridgeFile file, String newName, boolean isRetainExt, boolean isOverride) {
        File file1 = getFile(file, false);
        if (!FileUtil.exist(file1)) {
            return;
        }
        FileUtil.rename(file1, newName, isRetainExt, isOverride);
    }

    @Override
    public void copy(BridgeFile source, BridgeFile target, boolean isOverride) {
        FileUtil.copy(getFile(source, false), getFile(target, false), isOverride);
    }

    @Override
    public boolean isDirectory(BridgeFile file) {
        return getFile(file, false).isDirectory();
    }

    @Override
    public boolean isFile(BridgeFile file) {
        return getFile(file, false).isFile();
    }

    @Override
    public void mkdir(BridgeFile file) {
        FileUtil.mkdir(getFile(file, false));
    }

    @Override
    public void copyContent(BridgeFile source, BridgeFile target, boolean isOverride) {
        FileUtil.copyContent(getFile(source, false), getFile(target, false), isOverride);
    }
}
