/*
 * Decompiled with CFR 0.152.
 */
package com.github.hepeng86.mybatisplus.encrypt.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.conditions.segments.NormalSegmentList;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.hepeng86.mybatisplus.encrypt.Encrypt;
import com.github.hepeng86.mybatisplus.encrypt.constant.EncryptConstants;
import com.github.hepeng86.mybatisplus.encrypt.model.SensitiveField;
import com.github.hepeng86.mybatisplus.encrypt.properties.EncryptConfigProperties;
import com.github.hepeng86.mybatisplus.encrypt.util.ReflectionUtils;
import com.github.hepeng86.mybatisplus.encrypt.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.springframework.util.Assert;

public abstract class AbstractInterceptor
implements Interceptor {
    protected final Encrypt encrypt;
    protected final EncryptConfigProperties encryptConfigProperties;

    public AbstractInterceptor(Encrypt encrypt, EncryptConfigProperties encryptConfigProperties) {
        Objects.requireNonNull(encrypt, "encrypt should not be null!");
        String plaintext = "Encryption and Decryption Algorithm Preheating...";
        String encryptText = encrypt.encrypt(plaintext);
        String decryptText = encrypt.decrypt(encryptText);
        Assert.isTrue((boolean)plaintext.equals(decryptText), (String)"Inconsistency in Encryption and Decryption Algorithms");
        this.encrypt = encrypt;
        this.encryptConfigProperties = encryptConfigProperties;
    }

    protected void handleParameters(Object param) throws Exception {
        Map<String, SensitiveField> columnNameAndFieldMap = ReflectionUtils.getEncryptColumnNameAndFieldMapFromCache(param.getClass());
        if (CollectionUtils.isEmpty(columnNameAndFieldMap)) {
            return;
        }
        Set<Map.Entry<String, SensitiveField>> entries = columnNameAndFieldMap.entrySet();
        for (Map.Entry<String, SensitiveField> entry : entries) {
            SensitiveField field = entry.getValue();
            String value = field.getValue(param);
            if (StringUtils.isBlank((CharSequence)value)) continue;
            String encryptValue = this.convert(value, field.getJsonPaths());
            field.setValue(param, encryptValue);
        }
    }

    protected void handleParameters(AbstractWrapper<?, ?, ?> wrapper, BoundSql boundSql) throws Exception {
        AtomicInteger seq = this.getSeq(wrapper);
        if (seq.get() == -1) {
            return;
        }
        this.handleParameters(wrapper, seq, boundSql);
    }

    protected AtomicInteger getSeq(AbstractWrapper<?, ?, ?> wrapper) {
        MergeSegments mergeSegments = wrapper.getExpression();
        String sqlSegment = mergeSegments.getSqlSegment();
        Matcher matcher = EncryptConstants.VAL_PATTERN.matcher(sqlSegment);
        int seq = matcher.find() ? Integer.parseInt(matcher.group(1)) : -1;
        return new AtomicInteger(seq);
    }

    protected void handleParameters(AbstractWrapper<?, ?, ?> wrapper, AtomicInteger seq, BoundSql boundSql) throws Exception {
        SqlKeyword sqlKeyword = null;
        String columnName = null;
        int ignoreSteps = 0;
        MergeSegments mergeSegments = wrapper.getExpression();
        NormalSegmentList normalSegmentList = mergeSegments.getNormal();
        for (ISqlSegment iSqlSegment : normalSegmentList) {
            Object v2;
            if (iSqlSegment instanceof SqlKeyword) {
                sqlKeyword = (SqlKeyword)iSqlSegment;
                if (!Arrays.asList(SqlKeyword.BETWEEN, SqlKeyword.NOT_BETWEEN).contains(sqlKeyword)) continue;
                ignoreSteps = 2;
                continue;
            }
            if (iSqlSegment instanceof AbstractWrapper) {
                this.handleParameters((AbstractWrapper)iSqlSegment, seq, boundSql);
                continue;
            }
            if (Objects.isNull(columnName)) {
                columnName = iSqlSegment.getSqlSegment();
                continue;
            }
            int curSeq = seq.getAndIncrement();
            String curColumnName = columnName;
            columnName = null;
            if (ignoreSteps > 0) {
                --ignoreSteps;
                continue;
            }
            SensitiveField sensitiveField = ReflectionUtils.getSensitiveField(wrapper.getEntityClass(), curColumnName);
            if (Objects.isNull(sensitiveField) || this.isNullOrBlank(v2 = ReflectionUtils.getValue(iSqlSegment, "arg$2"))) continue;
            if (v2 instanceof List) {
                List values = (List)v2;
                int size = values.size();
                for (int i = 0; i < size; ++i) {
                    Object v21 = values.get(i);
                    if (i > 0) {
                        curSeq = seq.getAndIncrement();
                    }
                    if (this.isNullOrBlank(v21)) continue;
                    this.setParamNameValuePairs(curSeq, (String)v21, wrapper, sensitiveField, boundSql, sqlKeyword);
                }
                continue;
            }
            this.setParamNameValuePairs(curSeq, (String)v2, wrapper, sensitiveField, boundSql, sqlKeyword);
        }
    }

    protected boolean isNullOrBlank(Object o) {
        return Objects.isNull(o) || o instanceof String && StringUtils.isBlank((CharSequence)((String)o));
    }

    protected String convert(String value, String[] jsonPaths) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        if (jsonPaths.length == 0) {
            return this.convert(value);
        }
        Object json = JSON.parse((String)value);
        for (String jsonPath : jsonPaths) {
            Object jsonObj = JSONPath.eval((Object)json, (String)jsonPath);
            if (jsonObj instanceof List) {
                List list = (List)jsonObj;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    Object obj = list.get(i);
                    if (!this.isStringAndNotBlank(obj)) continue;
                    String jsonFieldValue = this.convert((String)obj);
                    String newJsonPath = StringUtil.replaceLast(jsonPath, ".", String.format("[%s].", i));
                    JSONPath.set((Object)json, (String)newJsonPath, (Object)jsonFieldValue);
                }
                continue;
            }
            if (!this.isStringAndNotBlank(jsonObj)) continue;
            String jsonFieldValue = this.convert((String)jsonObj);
            JSONPath.set((Object)json, (String)jsonPath, (Object)jsonFieldValue);
        }
        return JSON.toJSONString((Object)json);
    }

    protected boolean isStringAndNotBlank(Object o) {
        return o instanceof String && StringUtils.isNotBlank((CharSequence)((String)o));
    }

    protected abstract String convert(String var1);

    protected void setParamNameValuePairs(int seq, String value, AbstractWrapper<?, ?, ?> wrapper, SensitiveField sensitiveField, BoundSql boundSql, SqlKeyword sqlKeyword) throws Exception {
    }

    protected boolean isMixedQueryMode() {
        return this.encryptConfigProperties.isMixedQueryMode();
    }
}

