/*
 * Decompiled with CFR 0.152.
 */
package com.github.hepeng86.mybatisplus.encrypt.plugin;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.StringEscape;
import com.github.hepeng86.mybatisplus.encrypt.Encrypt;
import com.github.hepeng86.mybatisplus.encrypt.model.SensitiveField;
import com.github.hepeng86.mybatisplus.encrypt.plugin.AbstractInterceptor;
import com.github.hepeng86.mybatisplus.encrypt.properties.EncryptConfigProperties;
import com.github.hepeng86.mybatisplus.encrypt.util.ReflectionUtils;
import com.github.hepeng86.mybatisplus.encrypt.util.StringUtil;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class EncryptPrepareInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(EncryptPrepareInterceptor.class);

    public EncryptPrepareInterceptor(Encrypt encrypt, EncryptConfigProperties encryptConfigProperties) {
        super(encrypt, encryptConfigProperties);
    }

    public Object intercept(Invocation invocation) throws Exception {
        long start = System.currentTimeMillis();
        try {
            AbstractWrapper wrapper;
            MapperMethod.ParamMap paramMap;
            StatementHandler statementHandler;
            BoundSql boundSql;
            Object parameterObject;
            if (this.isMixedQueryMode() && (parameterObject = (boundSql = (statementHandler = (StatementHandler)invocation.getTarget()).getBoundSql()).getParameterObject()) instanceof MapperMethod.ParamMap && (paramMap = (MapperMethod.ParamMap)parameterObject).containsKey((Object)"ew") && Objects.nonNull(paramMap.get((Object)"ew")) && Objects.nonNull((wrapper = (AbstractWrapper)paramMap.get((Object)"ew")).getEntityClass()) && CollectionUtils.isNotEmpty((Collection)wrapper.getExpression().getNormal())) {
                this.handleParameters(wrapper, boundSql);
            }
        }
        catch (Exception e) {
            log.error("prepare encrypt fail", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        long cost = end - start;
        if (cost > 10L) {
            log.info("prepare encrypt cost:{}ms", (Object)cost);
        }
        return invocation.proceed();
    }

    @Override
    protected void setParamNameValuePairs(int seq, String value, AbstractWrapper<?, ?, ?> wrapper, SensitiveField sensitiveField, BoundSql boundSql, SqlKeyword sqlKeyword) throws IllegalAccessException, NoSuchFieldException {
        String genName = "MPGENVAL" + seq;
        if (Arrays.asList(SqlKeyword.IN, SqlKeyword.NOT_IN).contains(sqlKeyword)) {
            String property = String.format("ew.paramNameValuePairs.%s", genName);
            List parameterMappings = boundSql.getParameterMappings();
            int size = parameterMappings.size();
            for (int i = 0; i < size; ++i) {
                if (!((ParameterMapping)parameterMappings.get(i)).getProperty().equals(property)) continue;
                String newSql = StringUtil.replaceNthOccurrenceReverse(boundSql.getSql(), "?", String.format("%s, ?", StringEscape.escapeString((String)value)), size - i);
                ReflectionUtils.setField(boundSql, "sql", newSql);
                break;
            }
        }
    }

    @Override
    protected String convert(String value) {
        return this.encrypt.encrypt(value);
    }
}

