package com.github.hepeng86.mybatisplus.encrypt.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface EncryptField {

    /**
     * 支持JSON格式指定路径加密
     * 参考示例：
     * {
     * 	"attr1": "18852990715",
     * 	"obj2": {
     * 		"attr2": "18852990715"
     *        },
     * 	"obj3": [{
     * 		"attr3": "18852990715"
     *    }]
     * }
     * 1.加密attr1字段，$.attr1
     * 2.加密attr2字段，$.obj2.attr2
     * 3.加密attr3字段，$.obj3.attr3
     * @return 一个空的字符串数组，表示没有指定JSON路径。
     */
    String[] jsonPaths() default {};
}
