package com.github.hepeng86.mybatisplus.encrypt.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;

public abstract class AbstractFieldConvertor {

    protected String convert(String value, String[] jsonPaths) {
        if (StringUtils.isBlank(value)) {
            return value;
        }

        if (jsonPaths.length == 0) {
            return convert(value);
        }

        Object json = JSON.parse(value, Feature.OrderedField);
        for (String jsonPath : jsonPaths) {
            String[] nodeNames = jsonPath.split("\\.");
            Assert.isTrue(nodeNames.length >= 2, "The annotation @EncryptField arg jsonPaths contains '%s' incorrect format, need separate with '.', such as $.mobile.", jsonPath);
            setNode(json, nodeNames, 1);
        }
        return JSON.toJSONString(json);
    }

    private void setNode(Object json, String[] nodeNames, int index) {
        if (json instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)json;
            String nodeName = nodeNames[index];
            Object node = jsonObject.get(nodeName);
            if (isStringAndNotBlank(node)) {
                jsonObject.put(nodeName, convert((String)node));
            } else {
                setNode(node, nodeNames, index + 1);
            }
        } else if (json instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)json;
            for (Object node : jsonArray) {
                setNode(node, nodeNames, index);
            }
        }
    }

    protected boolean isStringAndNotBlank(Object o) {
        return o instanceof String && StringUtils.isNotBlank((String)o);
    }

    protected abstract String convert(String value);

}
