package com.github.hepeng86.mybatisplus.encrypt.model;

import java.lang.reflect.Field;
import lombok.AllArgsConstructor;
import lombok.Data;

@AllArgsConstructor
@Data
public class SensitiveField {

    private final Field field;

    private final String[] jsonPaths;

    public String getName() {
        return field.getName();
    }

    public String getValue(Object obj) throws IllegalAccessException {
        return (String)field.get(obj);
    }

    public void setValue(Object obj, Object value) throws IllegalAccessException {
        field.set(obj, value);
    }
}
