package com.github.hepeng86.mybatisplus.encrypt.model;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import lombok.Data;
import lombok.Setter;

@Setter
@Data
public class TableInfo<T> {

    private final Class<? extends BaseMapper<T>> mapperClass;

    private final Class<T> entityClass;

    private final SFunction<T, String>[] sensitiveColumns;

    /**
     * default use column 'ID'
     */
    private SFunction<T, Long> primaryColumn;

    @SafeVarargs
    public TableInfo(Class<? extends BaseMapper<T>> mapperClass, Class<T> entityClass, SFunction<T, String>... sensitiveColumns) {
        this(mapperClass, null, entityClass, sensitiveColumns);
    }

    @SafeVarargs
    public TableInfo(Class<? extends BaseMapper<T>> mapperClass, SFunction<T, Long> primaryColumn, Class<T> entityClass, SFunction<T, String>... sensitiveColumns) {
        this.mapperClass = mapperClass;
        this.primaryColumn = primaryColumn;
        this.entityClass = entityClass;
        this.sensitiveColumns = sensitiveColumns;
    }
}
