package com.github.hepeng86.mybatisplus.encrypt.plugin;

import com.github.hepeng86.mybatisplus.encrypt.Encrypt;
import com.github.hepeng86.mybatisplus.encrypt.properties.EncryptConfigProperties;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;

/**
 * ResultSet拦截
 * @author hepeng
 * @since 2024-07-10
 */
@Intercepts({
        @Signature(type = ResultSetHandler.class, method = "handleResultSets", args = {Statement.class})
})
@Slf4j
public class DecryptInterceptor extends AbstractInterceptor {

    public DecryptInterceptor(Encrypt encrypt, EncryptConfigProperties encryptConfigProperties) {
        super(encrypt, encryptConfigProperties);
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object intercept(Invocation invocation) throws Exception {
        final List<Object> results = (List<Object>) invocation.proceed();
        if (results.isEmpty()) {
            return results;
        }

        long start = System.currentTimeMillis();

        try {
            for (Object obj : results) {
                if (Objects.isNull(obj)) {
                    continue;
                }
                handleParameters(obj);
            }
        } catch (Exception e) {
            log.error("decrypt fail", e);
        }

        long end = System.currentTimeMillis();
        long cost = end - start;
        if (cost > 10) {
            log.info("decrypt cost:{}ms", cost);
        }

        return results;
    }

    @Override
    protected String convert(String value) {
        try {
            return encrypt.decrypt(value);
        } catch (Exception e) {
            if (isMixedQueryMode()) {
                return value;
            }
            throw e;
        }
    }
}
