/*
 * Decompiled with CFR 0.152.
 */
package com.github.hepeng86.mybatisplus.encrypt.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;

public abstract class AbstractFieldConvertor {
    protected String convert(String value, String[] jsonPaths) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        if (jsonPaths.length == 0) {
            return this.convert(value);
        }
        Object json = JSON.parse((String)value, (Feature[])new Feature[]{Feature.OrderedField});
        for (String jsonPath : jsonPaths) {
            String[] nodeNames = jsonPath.split("\\.");
            Assert.isTrue((nodeNames.length >= 2 ? 1 : 0) != 0, (String)"The annotation @EncryptField arg jsonPaths contains '%s' incorrect format, need separate with '.', such as $.mobile.", (Object[])new Object[]{jsonPath});
            this.setNode(json, nodeNames, 1);
        }
        return JSON.toJSONString((Object)json);
    }

    private void setNode(Object json, String[] nodeNames, int index) {
        if (json instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)json;
            String nodeName = nodeNames[index];
            Object node = jsonObject.get((Object)nodeName);
            if (this.isStringAndNotBlank(node)) {
                jsonObject.put(nodeName, (Object)this.convert((String)node));
            } else {
                this.setNode(node, nodeNames, index + 1);
            }
        } else if (json instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)json;
            for (Object node : jsonArray) {
                this.setNode(node, nodeNames, index);
            }
        }
    }

    protected boolean isStringAndNotBlank(Object o) {
        return o instanceof String && StringUtils.isNotBlank((CharSequence)((String)o));
    }

    protected abstract String convert(String var1);
}

