/*
 * Decompiled with CFR 0.152.
 */
package com.github.hepeng86.mybatisplus.encrypt.core;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.StringEscape;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import com.github.hepeng86.mybatisplus.encrypt.Encrypt;
import com.github.hepeng86.mybatisplus.encrypt.annotation.EncryptClass;
import com.github.hepeng86.mybatisplus.encrypt.annotation.EncryptField;
import com.github.hepeng86.mybatisplus.encrypt.constant.MySQLKeyword;
import com.github.hepeng86.mybatisplus.encrypt.core.AbstractFieldConvertor;
import com.github.hepeng86.mybatisplus.encrypt.model.SensitiveField;
import com.github.hepeng86.mybatisplus.encrypt.model.TableInfo;
import com.github.hepeng86.mybatisplus.encrypt.util.ReflectionUtils;
import com.github.hepeng86.mybatisplus.encrypt.util.SpringBeanUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CleanTableProcessor
extends AbstractFieldConvertor {
    private static final Logger log = LoggerFactory.getLogger(CleanTableProcessor.class);
    private final Encrypt encrypt;

    public CleanTableProcessor(Encrypt encrypt) {
        this.encrypt = encrypt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> void cleanTable(TableInfo<T> tableInfo) throws NoSuchFieldException, IllegalAccessException {
        String primaryColumnName;
        Class<BaseMapper<T>> mapperClass = tableInfo.getMapperClass();
        Assert.notNull(mapperClass, (String)"mapperClass must not be null", (Object[])new Object[0]);
        BaseMapper<T> baseMapper = SpringBeanUtil.getBean(mapperClass);
        Assert.notNull(mapperClass, (String)"The mapperClass '%s' bean not found", (Object[])new Object[]{mapperClass});
        Class<T> entityClass = tableInfo.getEntityClass();
        Assert.notNull(entityClass, (String)"entityClass must not be null", (Object[])new Object[0]);
        EncryptClass encryptClass = entityClass.getAnnotation(EncryptClass.class);
        Assert.notNull((Object)encryptClass, (String)"The entityClass '%s' is not @EncryptClass annotation", (Object[])new Object[]{entityClass});
        Object[] sensitiveColumns = tableInfo.getSensitiveColumns();
        Assert.notEmpty((Object[])sensitiveColumns, (String)"sensitiveColumns must not be null or empty", (Object[])new Object[0]);
        ArrayList<String> normalColumnNameList = new ArrayList<String>();
        for (Object sensitiveColumn : sensitiveColumns) {
            Field sensitiveField = ReflectionUtils.getFieldFromCache(entityClass, CleanTableProcessor.getFieldNameBySFunction(sensitiveColumn));
            EncryptField encryptField = sensitiveField.getAnnotation(EncryptField.class);
            Assert.notNull((Object)encryptField, (String)"The fieldName '%s' is not @EncryptField annotation", (Object[])new Object[]{sensitiveField.getName()});
            normalColumnNameList.add(ReflectionUtils.getColumnNameByField(sensitiveField));
        }
        TableName tableNameAnnotation = entityClass.getAnnotation(TableName.class);
        String tableName = Objects.isNull(tableNameAnnotation) || StringUtils.isBlank((CharSequence)tableNameAnnotation.value()) ? StringUtils.camelToUnderline((String)entityClass.getSimpleName()) : tableNameAnnotation.value();
        log.info("Currently cleaning tableName:{} and columnNames:{}", (Object)tableName.toUpperCase(), normalColumnNameList);
        SFunction<T, Long> primaryColumn = tableInfo.getPrimaryColumn();
        if (Objects.isNull(primaryColumn)) {
            primaryColumnName = "ID";
        } else {
            Field primaryField = ReflectionUtils.getFieldFromCache(entityClass, CleanTableProcessor.getFieldNameBySFunction(primaryColumn));
            primaryColumnName = ReflectionUtils.getColumnNameByField(primaryField);
        }
        String normalColumnNames = String.join((CharSequence)",", normalColumnNameList);
        Map<String, SensitiveField> columnNameAndFieldMap = ReflectionUtils.getEncryptColumnNameAndFieldMapFromCache(tableInfo.getEntityClass());
        long retryId = 0L;
        long id = 0L;
        block1: while (true) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.setEntityClass(tableInfo.getEntityClass());
            queryWrapper.select(new String[]{primaryColumnName, normalColumnNames});
            queryWrapper.gt((Object)primaryColumnName, (Object)id);
            queryWrapper.last(String.format("%s %s %s %s %s %s", SqlKeyword.OR.getSqlSegment(), primaryColumnName, SqlKeyword.GT.getSqlSegment(), id, MySQLKeyword.LIMIT.getSqlSegment(), 200));
            List list = baseMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)list)) return;
            for (Object entity : list) {
                id = (Long)ReflectionUtils.getValue(entity, StringUtils.underlineToCamel((String)primaryColumnName));
                Map<String, String> nonBlankColumnMap = CleanTableProcessor.getNonBlankColumnMap(entity, normalColumnNameList);
                if (CollectionUtils.isEmpty(nonBlankColumnMap)) continue;
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)primaryColumnName, (Object)id);
                StringBuilder sqlSegment = new StringBuilder();
                sqlSegment.append(String.format(" %s %s %s %s", SqlKeyword.OR.getSqlSegment(), primaryColumnName, SqlKeyword.EQ.getSqlSegment(), id));
                Set<Map.Entry<String, String>> entries = nonBlankColumnMap.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    SensitiveField field = columnNameAndFieldMap.get(entry.getKey());
                    String encryptValue = this.convert(entry.getValue(), field.getJsonPaths());
                    updateWrapper.in((Object)entry.getKey(), new Object[]{entry.getValue(), encryptValue});
                    sqlSegment.append(String.format(" %s %s %s (%s, %s)", SqlKeyword.AND.getSqlSegment(), entry.getKey(), SqlKeyword.IN.getSqlSegment(), StringEscape.escapeString((String)entry.getValue()), StringEscape.escapeString((String)encryptValue)));
                }
                updateWrapper.last(sqlSegment.toString());
                int updatedCnt = baseMapper.update(entity, (Wrapper)updateWrapper);
                if (updatedCnt == 0) {
                    if (retryId != id) {
                        retryId = id--;
                        continue block1;
                    }
                    log.warn("Currently cleaning tableName:{} [{}:{}] update fail", new Object[]{tableName.toUpperCase(), primaryColumnName, id});
                }
                retryId = 0L;
            }
            if (list.size() < 200) return;
        }
    }

    private static <T> String getFieldNameBySFunction(SFunction<T, ?> sFunction) {
        SerializedLambda lambda = LambdaUtils.resolve(sFunction);
        return PropertyNamer.methodToProperty((String)lambda.getImplMethodName());
    }

    private static <T> Map<String, String> getNonBlankColumnMap(T entity, List<String> columnNameList) throws NoSuchFieldException, IllegalAccessException {
        HashMap<String, String> nonBlankColumnMap = new HashMap<String, String>();
        for (String columnName : columnNameList) {
            String columnValue = (String)ReflectionUtils.getValue(entity, StringUtils.underlineToCamel((String)columnName));
            if (!StringUtils.isNotBlank((CharSequence)columnValue)) continue;
            nonBlankColumnMap.put(columnName, columnValue);
        }
        return nonBlankColumnMap;
    }

    @Override
    protected String convert(String value) {
        return this.encrypt.encrypt(value);
    }
}

