/*
 * Decompiled with CFR 0.152.
 */
package com.github.hepeng86.mybatisplus.encrypt.plugin;

import com.github.hepeng86.mybatisplus.encrypt.Encrypt;
import com.github.hepeng86.mybatisplus.encrypt.plugin.AbstractInterceptor;
import com.github.hepeng86.mybatisplus.encrypt.properties.EncryptConfigProperties;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class DecryptInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DecryptInterceptor.class);

    public DecryptInterceptor(Encrypt encrypt, EncryptConfigProperties encryptConfigProperties) {
        super(encrypt, encryptConfigProperties);
    }

    public Object intercept(Invocation invocation) throws Exception {
        List results = (List)invocation.proceed();
        if (results.isEmpty()) {
            return results;
        }
        long start = System.currentTimeMillis();
        try {
            for (Object obj : results) {
                if (Objects.isNull(obj)) continue;
                this.handleParameters(obj);
            }
        }
        catch (Exception e) {
            log.error("decrypt fail", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        long cost = end - start;
        if (cost > 10L) {
            log.info("decrypt cost:{}ms", (Object)cost);
        }
        return results;
    }

    @Override
    protected String convert(String value) {
        try {
            return this.encrypt.decrypt(value);
        }
        catch (Exception e) {
            if (this.isMixedQueryMode()) {
                return value;
            }
            throw e;
        }
    }
}

