/*
 * Decompiled with CFR 0.152.
 */
package com.github.hepeng86.mybatisplus.encrypt.plugin;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.hepeng86.mybatisplus.encrypt.Encrypt;
import com.github.hepeng86.mybatisplus.encrypt.constant.EncryptConstants;
import com.github.hepeng86.mybatisplus.encrypt.model.SensitiveField;
import com.github.hepeng86.mybatisplus.encrypt.plugin.AbstractInterceptor;
import com.github.hepeng86.mybatisplus.encrypt.properties.EncryptConfigProperties;
import com.github.hepeng86.mybatisplus.encrypt.util.ReflectionUtils;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class EncryptParameterInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(EncryptParameterInterceptor.class);

    public EncryptParameterInterceptor(Encrypt encrypt, EncryptConfigProperties encryptConfigProperties) {
        super(encrypt, encryptConfigProperties);
    }

    public Object intercept(Invocation invocation) throws Exception {
        long start = System.currentTimeMillis();
        ParameterHandler parameterHandler = (ParameterHandler)invocation.getTarget();
        Object parameterObject = parameterHandler.getParameterObject();
        if (Objects.isNull(parameterObject)) {
            return invocation.proceed();
        }
        try {
            if (parameterObject instanceof MapperMethod.ParamMap) {
                MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameterObject;
                if (paramMap.containsKey((Object)"ew") && Objects.nonNull(paramMap.get((Object)"ew"))) {
                    AbstractWrapper wrapper = (AbstractWrapper)paramMap.get((Object)"ew");
                    if (Objects.nonNull(wrapper.getEntity())) {
                        wrapper.setEntity(EncryptParameterInterceptor.clone(wrapper.getEntity()));
                        this.handleParameters(wrapper.getEntity());
                    }
                    if (Objects.nonNull(wrapper.getEntityClass()) && StringUtils.isNotBlank((CharSequence)wrapper.getSqlSet())) {
                        this.handleParameters(wrapper);
                    }
                    if (Objects.nonNull(wrapper.getEntityClass()) && CollectionUtils.isNotEmpty((Collection)wrapper.getExpression().getNormal())) {
                        this.handleParameters(wrapper, null);
                    }
                }
                if (paramMap.containsKey((Object)"et") && Objects.nonNull(paramMap.get((Object)"et"))) {
                    paramMap.put((Object)"et", EncryptParameterInterceptor.clone(paramMap.get((Object)"et")));
                    this.handleParameters(paramMap.get((Object)"et"));
                }
            } else if (!CollectionUtils.isEmpty(ReflectionUtils.getEncryptColumnNameAndFieldMapFromCache(parameterObject.getClass()))) {
                ReflectionUtils.setField(parameterHandler, "parameterObject", EncryptParameterInterceptor.clone(parameterObject));
                this.handleParameters(parameterHandler.getParameterObject());
            }
        }
        catch (Exception e) {
            log.error("parameter encrypt fail", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        long cost = end - start;
        if (cost > 10L) {
            log.info("parameter encrypt cost:{}ms", (Object)cost);
        }
        return invocation.proceed();
    }

    public static Object clone(Object source) {
        Object result = BeanUtils.instantiateClass(source.getClass());
        BeanUtils.copyProperties((Object)source, (Object)result);
        return result;
    }

    protected void handleParameters(AbstractWrapper<?, ?, ?> wrapper) {
        String[] sqlSet;
        for (String sql : sqlSet = wrapper.getSqlSet().split(",")) {
            Matcher matcher = EncryptConstants.SQL_SET_PATTERN.matcher(sql);
            while (matcher.find()) {
                String columnName = matcher.group(1);
                SensitiveField sensitiveField = ReflectionUtils.getSensitiveField(wrapper.getEntityClass(), columnName);
                if (Objects.isNull(sensitiveField)) continue;
                String genName = "MPGENVAL" + matcher.group(2);
                String value = (String)wrapper.getParamNameValuePairs().get(genName);
                if (StringUtils.isBlank((CharSequence)value)) continue;
                String encryptField = this.convert(value, sensitiveField.getJsonPaths());
                wrapper.getParamNameValuePairs().put(genName, encryptField);
            }
        }
    }

    @Override
    protected void setParamNameValuePairs(int seq, String value, AbstractWrapper<?, ?, ?> wrapper, SensitiveField sensitiveField, BoundSql boundSql, SqlKeyword sqlKeyword) {
        String genName = "MPGENVAL" + seq;
        String encryptField = this.convert(value, sensitiveField.getJsonPaths());
        wrapper.getParamNameValuePairs().put(genName, encryptField);
    }

    @Override
    protected String convert(String value) {
        return this.encrypt.encrypt(value);
    }
}

