package org.wxz.base.config.filter;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.wxz.base.filter.TokenFilter;
import org.wxz.tools.oracle.type.util.StringUtil;

import javax.servlet.Filter;

@Slf4j
@Configuration
public class ConfigTokenFilter {
    
    @Bean
    public TokenFilter tokenFilter() {
        return new TokenFilter();
    }
    
    @Bean
    public FilterRegistrationBean<Filter> tokenFilterRegistrationBean() {
        FilterRegistrationBean<Filter> tokenFilterRegistrationBean = new FilterRegistrationBean<>();
        tokenFilterRegistrationBean.setFilter(new DelegatingFilterProxy(StringUtil.nameVariable(TokenFilter.class)));
        tokenFilterRegistrationBean.addUrlPatterns("/*");
        tokenFilterRegistrationBean.setOrder(Ordered.LOWEST_PRECEDENCE);
        log.info("==========注册 'TokenFilter' 成功==========");
        return tokenFilterRegistrationBean;
    }
}