package org.wxz.base.config.redis.value;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.wxz.base.config.redis.key.ConfigRedisKeyExt;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

@Slf4j
@RefreshScope
@Configuration
public class ConfigRedisValueExt<K, V> extends ConfigRedisValue<K, V> {
    
    @Resource
    protected StringRedisTemplate stringRedisTemplate;
    
    @Resource(name = "fastJsonRedisTemplate")
    protected RedisTemplate<K, V> fastJsonRedisTemplate;
    
    @Value("${system.timeout.token:1440}")
    private long tokenTimeout;
    
    @Value("${system.timeout.image-code:5}")
    private long imageCodeTimeout;
    
    @Resource
    private ConfigRedisKeyExt configRedisKeyExt;
    
    public void setToken(String token, String userId) {
        stringRedisTemplate.opsForValue().set(configRedisKeyExt.getToken() + token, userId, tokenTimeout, TimeUnit.MINUTES);
    }
    
    public String getToken(String token) {
        return stringRedisTemplate.opsForValue().get(configRedisKeyExt.getToken() + token);
    }
    
    public void delToken(String token) {
        stringRedisTemplate.delete(configRedisKeyExt.getToken() + token);
    }
    
    public void flushToken() {
        for (String key : stringRedisTemplate.keys(configRedisKeyExt.getToken() + "*")) {
            stringRedisTemplate.delete(key);
        }
    }
    
    public void setImageCode(String uuid, String imageCode) {
        stringRedisTemplate.opsForValue().set(configRedisKeyExt.getImageCode() + uuid, imageCode, imageCodeTimeout, TimeUnit.MINUTES);
    }
    
    public String getImageCode(String uuid) {
        return stringRedisTemplate.opsForValue().get(configRedisKeyExt.getImageCode() + uuid);
    }
    
    public void delImageCode(String uuid) {
        stringRedisTemplate.delete(configRedisKeyExt.getImageCode() + uuid);
    }
    
    public void flushImageCode() {
        for (String key : stringRedisTemplate.keys(configRedisKeyExt.getImageCode() + "*")) {
            stringRedisTemplate.delete(key);
        }
    }
}