package org.wxz.base.filter.callback.impl;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;
import org.wxz.base.config.header.ConfigHeader;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.filter.callback.TokenFilterCallback;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.tools.apache.log.util.LogUtil;
import org.wxz.tools.oracle.empty.util.EmptyUtil;
import org.wxz.tools.oracle.servlet.util.HttpServletRequestUtil;
import org.wxz.tools.oracle.servlet.util.HttpServletResponseUtil;

import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@RefreshScope
@Configuration("tokenFilterCallback")
public class TokenFilterCallbackImpl implements TokenFilterCallback {
    
    private static final List<String> BLACK_LIST = new ArrayList<String>() {
        {
            add("/base");
            add("/business");
        }
    };
    
    @Value("${knife4j.basic.password}")
    private String password;
    
    @Value("${system.index.url}")
    private String url;
    
    @Resource
    private ConfigHeader configHeader;
    
    @Resource
    private ConfigRedisValueExt<String, String> configRedisValueExt;
    
    @Override
    public boolean service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (password.equals(request.getHeader(configHeader.getKnife4j()))) {
            return true;
        }
        boolean todo = true;
        boolean stop = false;
        for (String path : BLACK_LIST) {
            if (request.getRequestURI().contains(path)) {
                stop = true;
                break;
            }
        }
        if (stop) {
            String token = request.getHeader(configHeader.getToken());
            if (EmptyUtil.isNull(token)) {
                token = request.getParameter(configHeader.getToken());
            }
            String userId = null;
            try {
                userId = configRedisValueExt.getToken(token);
            } catch (Exception e) {
                LogUtil.error("认证失败", e);
            }
            if (EmptyUtil.isNull(userId)) {
                if (EmptyUtil.isNull(HttpServletRequestUtil.xRequestedWith(request))) {
                    response.sendRedirect(url);
                    todo = false;
                } else {
                    ResponseModel<String> responseModel = ResponseUtil.initResponseModel();
                    ResponseUtil.sessionTimeout(responseModel);
                    HttpServletResponseUtil.printJson(response, responseModel);
                    todo = false;
                }
            }
        }
        return todo;
    }
}