package org.wxz.business.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.business.service.UploadService;

import javax.annotation.Resource;
import java.util.List;

@Api(value = "UploadController", tags = "上传相关接口")
@Slf4j
@RestController
public class UploadController {
    
    @Resource
    private UploadService uploadService;
    
    @ApiOperation("上传：多个")
    @PostMapping({"upload/files", "base/upload/files"})
    public ResponseModel<List<String>> files(ResponseModel<List<String>> responseModel, @RequestParam("files") MultipartFile[] multipartFiles) {
        uploadService.files(responseModel, multipartFiles);
        return responseModel;
    }
    
    @ApiOperation("上传：单个")
    @PostMapping({"upload/file", "base/upload/file"})
    public ResponseModel<String> file(ResponseModel<String> responseModel, @RequestParam("file") MultipartFile multipartFile) {
        uploadService.file(responseModel, multipartFile);
        return responseModel;
    }
}