package org.wxz.business.service.impl;

import org.springframework.stereotype.Service;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.response.PositionResponse;
import org.wxz.business.service.PositionService;
import org.wxz.tools.baidu.position.ip.param.IpParam;
import org.wxz.tools.baidu.position.ip.result.IpInfo;
import org.wxz.tools.baidu.position.ip.util.IpUtil;

import javax.servlet.http.HttpServletRequest;

@Service
public class PositionServiceImpl implements PositionService {
    
    @Override
    public void position(ResponseModel<PositionResponse> responseModel, HttpServletRequest request) {
        IpInfo ipInfo = IpUtil.ipClass(new IpParam(request.getRemoteAddr()));
        ResponseUtil.executeSuccess(
                responseModel,
                new PositionResponse(
                        request.getRemoteAddr(),
                        ipInfo.getAddress(),
                        ipInfo.getContent().getAddressDetail().getProvince(),
                        ipInfo.getContent().getAddressDetail().getCity(),
                        ipInfo.getContent().getPoint().getX(),
                        ipInfo.getContent().getPoint().getY()
                )
        );
    }
}