package org.wxz.base.config.filter;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.wxz.tools.oracle.type.util.StringUtil;

import javax.servlet.Filter;

@Slf4j
@Configuration
public class ConfigTokenFilter {
    
    @Value("${system.filter.order.token:3}")
    private int order;
    
    @Bean
    public TokenFilter tokenFilter() {
        return new TokenFilter();
    }
    
    @Bean
    public FilterRegistrationBean<Filter> tokenFilterRegistrationBean() {
        FilterRegistrationBean<Filter> tokenFilterRegistrationBean = new FilterRegistrationBean<>();
        tokenFilterRegistrationBean.setFilter(new DelegatingFilterProxy(StringUtil.nameVariable(TokenFilter.class)));
        tokenFilterRegistrationBean.addUrlPatterns("/*");
        tokenFilterRegistrationBean.setOrder(order);
        log.info("==========注册 'TokenFilter' 成功==========");
        return tokenFilterRegistrationBean;
    }
}