package org.wxz.base.config.filter.callback.impl;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;
import org.wxz.base.config.filter.callback.TokenFilterCallback;
import org.wxz.base.config.header.ConfigHeader;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.tools.apache.log.util.LogUtil;
import org.wxz.tools.oracle.empty.util.EmptyUtil;
import org.wxz.tools.oracle.servlet.util.HttpServletRequestUtil;
import org.wxz.tools.oracle.servlet.util.HttpServletResponseUtil;

import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Slf4j
@RefreshScope
@Configuration("tokenFilterCallback")
@ConditionalOnProperty(prefix = "base", name = "TokenFilterCallback", havingValue = "open", matchIfMissing = true)
public class TokenFilterCallbackImpl implements TokenFilterCallback {
    
    @Value("${system.safety.black-list:/base/,/business/,/logout,/base/logout,/position,/base/position,/upload/files,/base/upload/files,/upload/file,/base/upload/file}")
    private String blackList;
    
    @Value("${system.safety.white-list:/logout,/base/logout,/position,/base/position,/upload/files,/base/upload/files,/upload/file,/base/upload/file,/base/area/listByPId,/base/dept/findAll}")
    private String whiteList;
    
    @Value("${knife4j.basic.password}")
    private String password;
    
    @Value("${system.index.url}")
    private String url;
    
    @Resource
    private ConfigHeader configHeader;
    
    @Resource
    private ConfigRedisValueExt<String, String> configRedisValueExt;
    
    @Override
    public boolean service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (password.equals(request.getHeader(configHeader.getKnife4j()))) {
            return true;
        }
        boolean todo = true;
        boolean stop = false;
        for (String path : blackList.split(",")) {
            if (request.getRequestURI().contains(path)) {
                stop = true;
                break;
            }
        }
        for (String path : whiteList.split(",")) {
            if (request.getRequestURI().contains(path)) {
                stop = false;
                break;
            }
        }
        if (stop) {
            String token = request.getHeader(configHeader.getToken());
            if (EmptyUtil.isNull(token)) {
                token = request.getParameter(configHeader.getToken());
            }
            String userId = null;
            try {
                userId = configRedisValueExt.getToken(token);
            } catch (Exception e) {
                LogUtil.error("认证失败", e);
            }
            if (EmptyUtil.isNull(userId)) {
                if (EmptyUtil.isNull(HttpServletRequestUtil.xRequestedWith(request))) {
                    response.sendRedirect(url);
                    todo = false;
                } else {
                    ResponseModel<String> responseModel = ResponseUtil.initResponseModel();
                    ResponseUtil.sessionTimeout(responseModel);
                    HttpServletResponseUtil.printJson(response, responseModel);
                    todo = false;
                }
            }
        }
        return todo;
    }
}