package org.wxz.business.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.business.model.BaseArea;
import org.wxz.business.service.BaseAreaService;
import org.wxz.tools.oracle.empty.util.EmptyUtil;

import javax.annotation.Resource;
import java.util.List;

@Api(value = "BaseAreaController", tags = "基础：行政区相关接口")
@RestController
@RequestMapping("base/area")
public class BaseAreaController {
    
    @Resource
    private BaseAreaService baseAreaService;
    
    @ApiOperation("列表：通过父主键（已放开鉴权）")
    @PostMapping({"listByPId", "listByPId/{pId}"})
    public ResponseModel<List<BaseArea>> listByPId(ResponseModel<List<BaseArea>> responseModel, @PathVariable(required = false) String pId) {
        baseAreaService.listByPId(responseModel, EmptyUtil.isNull(pId) ? "0" : pId);
        return responseModel;
    }
}