package org.wxz.business.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.business.service.LogoutService;

import javax.annotation.Resource;

@Api(value = "LogoutController", tags = "登出相关接口")
@Slf4j
@RestController
public class LogoutController {
    
    @Resource
    private LogoutService logoutService;
    
    @ApiOperation("登出（历史遗留问题，后期建议都走鉴权）")
    @GetMapping({"logout", "base/logout"})
    public ResponseModel<Boolean> logout(ResponseModel<Boolean> responseModel, @RequestHeader("token") String token) {
        logoutService.logout(responseModel, token);
        return responseModel;
    }
}