package org.wxz.business.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.wxz.tools.oracle.uuid.util.UUIDUtil;

import java.io.Serializable;

@Slf4j
@ApiModel(value = "ImageCodeResponse", description = "图片验证码返回对象")
@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
public class ImageCodeResponse implements Serializable {
    
    @ApiModelProperty("主键")
    private String imgId = UUIDUtil.uuidNoLineAndToLower();
    
    @ApiModelProperty("路径")
    private String imgSrc;
    
}