package org.wxz.business.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;

@Slf4j
@ApiModel(value = "PositionResponse", description = "定位返回对象")
@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
public class PositionResponse implements Serializable {
    
    @ApiModelProperty("ip")
    private String ip;
    
    @ApiModelProperty("地址")
    private String address;
    
    @ApiModelProperty("省")
    private String province;
    
    @ApiModelProperty("市")
    private String city;
    
    @ApiModelProperty("经度")
    private Double longitude;
    
    @ApiModelProperty("维度")
    private Double latitude;
    
}