package org.wxz.business.service.impl;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.wxz.base.config.path.ConfigPathExt;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.service.UploadService;
import org.wxz.tools.oracle.io.file.util.FileNameUtil;
import org.wxz.tools.oracle.io.file.util.FileWriteUtil;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class UploadServiceImpl implements UploadService {
    
    @Resource
    private ConfigPathExt configPathExt;
    
    @Override
    public void files(ResponseModel<List<String>> responseModel, MultipartFile[] multipartFiles) {
        List<String> fileUrlList = new ArrayList<>();
        for (MultipartFile multipartFile : multipartFiles) {
            fileUrlList.add(upload(multipartFile));
        }
        ResponseUtil.executeSuccess(responseModel, fileUrlList);
    }
    
    @Override
    public void file(ResponseModel<String> responseModel, MultipartFile multipartFile) {
        ResponseUtil.executeSuccess(responseModel, upload(multipartFile));
    }
    
    private String upload(MultipartFile multipartFile) {
        String md5Name = FileNameUtil.md5Name(multipartFile);
        FileWriteUtil.write(multipartFile, configPathExt.getAbsolutePath(), md5Name);
        return configPathExt.getRelativePath() + "/" + md5Name;
    }
}