package org.wxz.base.config.path;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.io.Serializable;

/**
 * 配置路径
 *
 * Author xzwu6 2020/12/11
 */
@Configuration
@Getter
@Setter
@Slf4j
public class ConfigPathExt extends ConfigPath implements Serializable {
    
    private String imageCodePath = "image/code";
    
    private String imageCodeAbsolutePath;
    
    private String imageCodeRelativePath;
    
    public String getImageCodeAbsolutePath() {
        return getAbsolutePath() + "/" + getImageCodePath();
    }
    
    public String getImageCodeRelativePath() {
        return getRelativePath() + "/" + getImageCodePath();
    }
}