package org.wxz.base.config.redis.value;

import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.wxz.base.config.redis.key.ConfigRedisKeyExt;
import org.wxz.base.config.redis.model.TokenForUser;
import org.wxz.base.config.redis.redistemplate.FastJsonRedisTemplate;
import org.wxz.tools.alibaba.fastjson.util.FastJsonUtil;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

@Slf4j
@Getter
@RefreshScope
@Configuration
public class ConfigRedisValueExt<K, HK, HV> extends ConfigRedisValue<K, HK, HV> {
    
    @Resource
    protected StringRedisTemplate stringRedisTemplate;
    
    @Resource
    protected FastJsonRedisTemplate<K, HK, HV> fastJsonRedisTemplate;
    
    @Value("${system.timeout.token:1440}")
    private long tokenTimeout;
    
    @Value("${system.timeout.image-code:5}")
    private long imageCodeTimeout;
    
    @Resource
    private ConfigRedisKeyExt configRedisKeyExt;
    
    public void setTokenForUser(String token, TokenForUser user) {
        setTokenForObject(token, user);
    }
    
    public void setTokenForObject(String token, Object user) {
        setToken(token, FastJsonUtil.toJson(user));
    }
    
    public void setToken(String token, String userId) {
        stringRedisTemplate.opsForValue().set(configRedisKeyExt.getToken() + token, userId, tokenTimeout, TimeUnit.MINUTES);
    }
    
    public TokenForUser getTokenForUser(String token) {
        return getTokenForObject(token, TokenForUser.class);
    }
    
    public <T> T getTokenForObject(String token, Class<T> clazz) {
        return FastJsonUtil.toClass(getToken(token), clazz);
    }
    
    public String getToken(String token) {
        return stringRedisTemplate.opsForValue().get(configRedisKeyExt.getToken() + token);
    }
    
    public void delToken(String token) {
        stringRedisTemplate.delete(configRedisKeyExt.getToken() + token);
    }
    
    public void flushToken() {
        for (String key : stringRedisTemplate.keys(configRedisKeyExt.getToken() + "*")) {
            stringRedisTemplate.delete(key);
        }
    }
    
    public void setImageCode(String uuid, String imageCode) {
        stringRedisTemplate.opsForValue().set(configRedisKeyExt.getImageCode() + uuid, imageCode, imageCodeTimeout, TimeUnit.MINUTES);
    }
    
    public String getImageCode(String uuid) {
        return stringRedisTemplate.opsForValue().get(configRedisKeyExt.getImageCode() + uuid);
    }
    
    public void delImageCode(String uuid) {
        stringRedisTemplate.delete(configRedisKeyExt.getImageCode() + uuid);
    }
    
    public void flushImageCode() {
        for (String key : stringRedisTemplate.keys(configRedisKeyExt.getImageCode() + "*")) {
            stringRedisTemplate.delete(key);
        }
    }
}