package org.wxz.base.config.xxljob.handler;

import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.wxz.base.config.path.ConfigPathExt;
import org.wxz.tools.apache.log.util.LogUtil;
import org.wxz.tools.oracle.io.file.util.FileDeleteUtil;

import javax.annotation.Resource;

@Slf4j
@Configuration
public class ImageCodeHandler {
    
    @Resource
    private ConfigPathExt configPathExt;
    
    @XxlJob("ImageCodeHandler")
    public ReturnT<String> execute() throws Exception {
        try {
            FileDeleteUtil.delete(configPathExt.getImageCodeAbsolutePath());
            return ReturnT.SUCCESS;
        } catch (Exception e) {
            LogUtil.error(e);
            return ReturnT.FAIL;
        }
    }
}