package org.wxz.base.config.xxljob.handler;

import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.tools.apache.log.util.LogUtil;

import javax.annotation.Resource;

@Slf4j
@Configuration
public class TokenHandler {
    
    @Resource
    private ConfigRedisValueExt<String, String, String> configRedisValueExt;
    
    @XxlJob("TokenHandler")
    public ReturnT<String> execute() throws Exception {
        try {
            configRedisValueExt.flushToken();
            return ReturnT.SUCCESS;
        } catch (Exception e) {
            LogUtil.error(e);
            return ReturnT.FAIL;
        }
    }
}